
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.Windows.Navigation
Imports System.Windows.Shapes
Imports System.IO
Imports System.ComponentModel
Imports System.Windows.Markup
Imports System.Xml
Imports AssetsDBModel

Namespace Assets002ns
    ' <summary>
    ' Interaction logic for Assets_v8Window.xaml
    ' </summary>
    Class Assets_v8Window
        Inherits WindowBase
        Private assetsdbEntities As AssetsDBModel.AssetsDBEntities = Nothing
        Private asset_management2ViewSource As System.Windows.Data.CollectionViewSource = Nothing
        Private asset_management2Query As System.Data.Objects.ObjectQuery(Of asset_management2) = Nothing

        Private Function Getasset_management2Query(ByVal assetsdbEntities As AssetsDBModel.AssetsDBEntities) As System.Data.Objects.ObjectQuery(Of asset_management2)
            ' Auto generated code
            Dim asset_management2Query As System.Data.Objects.ObjectQuery(Of asset_management2) = assetsdbEntities.asset_management2
            asset_management2= asset_management2Query
            ' Returns an ObjectQuery.
            Return asset_management2Query
        End Function

        Private Sub Window_Loaded(ByVal sender As System.Object, ByVal e As System.Windows.RoutedEventArgs) Handles MyBase.Loaded
            assetsdbEntities = New AssetsDBModel.AssetsDBEntities()
            ' Load data into asset_management2. You can modify this code as needed.
            asset_management2ViewSource = DirectCast(Me.FindResource("asset_management2ViewSource"), System.Windows.Data.CollectionViewSource)
            asset_management2Query = Me.Getasset_management2Query(assetsdbEntities)
            asset_management2ViewSource.Source = asset_management2Query
            Me.ReBind()
        End Sub

        Public Sub New()
            ' This call is required by the designer.
            InitializeComponent()

            ' Add any initialization after the InitializeComponent() call.
        End Sub

        Protected Friend Sub Show_Toolbar()
            If Me.toolBarUserControl1.IsVisible Then
                Me.toolBarUserControl1.Visibility = Windows.Visibility.Hidden
            Else
                Me.toolBarUserControl1.Visibility = Windows.Visibility.Visible
            End If
        End Sub

        Protected Friend Overrides ReadOnly Property TotalRecords() As Integer
            Get
                Dim currentTable = assetsdbEntities.asset_management2.AsQueryable()
                Dim maxRecords As Integer = currentTable.Count()
                Return maxRecords
            End Get
        End Property

        Protected Friend Overrides Property CurrentRecordPosition() As Double
            Get
                If asset_management2ViewSource IsNot Nothing Then
                    Return CDbl(asset_management2ViewSource.View.CurrentPosition)
                Else
                    Return 0.0

                End If
            End Get

            Set(ByVal value As Double)
                Dim newPosition As Integer = CInt(Math.Truncate(value))
                Dim currentTable = assetsdbEntities.asset_management2.AsQueryable()
                Dim maxRecords As Integer = currentTable.Count() - 1

                If newPosition > maxRecords Then
                    newPosition = maxRecords
                End If

                asset_management2ViewSource.View.MoveCurrentToPosition(newPosition)
                NotifyPropertyChanged("CurrentRecordPosition")
            End Set
        End Property

        Protected Friend Overrides Sub SaveRecords()
            Try
                Me.assetsdbEntities.SaveChanges()
            Catch generatedExceptionName As Exception
                'Error handling                
                Throw
            End Try
        End Sub

        Protected Friend Overrides Sub NewRecord()
            Try
                Dim entity = assetsdbEntities.CreateObject(Of asset_management2)()
                assetsdbEntities.AddToasset_management2(entity)
            Catch generatedExceptionName As Exception
                'Error Handling
                Throw
            End Try

            Me.SaveRecords()
            asset_management2ViewSource.Source = asset_management2Query
            asset_management2ViewSource.View.MoveCurrentToLast()

            NotifyPropertyChanged("TotalRecords")
        End Sub

        Protected Friend Overrides Sub DeleteCurrentRecord()
            Try
                Dim entity = asset_management2ViewSource.View.CurrentItem
                assetsdbEntities.DeleteObject(entity)
            Catch generatedExceptionName As Exception
                'Error Handling        
                Throw
            End Try
            Me.SaveRecords()
            asset_management2ViewSource.View.Refresh()
            NotifyPropertyChanged("TotalRecords")
        End Sub

        Protected Friend Overrides Sub MoveToNextRecord()
            If asset_management2ViewSource.View.CurrentPosition < DirectCast(asset_management2ViewSource.View, CollectionView).Count - 1 Then
                asset_management2ViewSource.View.MoveCurrentToNext()
            End If
            Me.SaveRecords()
            NotifyPropertyChanged("CurrentRecordPosition")
        End Sub

        Protected Friend Overrides Sub MoveToPreviousRecord()
            If asset_management2ViewSource.View.CurrentPosition > 0 Then
                asset_management2ViewSource.View.MoveCurrentToPrevious()
            End If
            Me.SaveRecords()
            NotifyPropertyChanged("CurrentRecordPosition")
        End Sub

        Protected Friend Overrides Sub ReBind()
            Me.Bind_Menu_asset_management2__category()
            Me.Chkbx_asset_management2__book_value_RebindCheckBoxes()
            Me.Radio_asset_management2__radio_btn_test_fld2_RebindRadioButtons()
            Me.Chkbx_asset_management2__checkbox_test_fld2_RebindCheckBoxes()
            Me.Radio_asset_management2__radio_btn_test_fld1_RebindRadioButtons()
            Me.Bind_Menu_asset_management2__vl_test_fld1_numeric()
            Me.Bind_Menu_asset_management2__vl_test_fld2_numeric()
            Me.Chkbx_asset_management2__checkbox_test_fld1_RebindCheckBoxes()
            Me.Bind_Menu_asset_management2__vl_test_fld1_text()
            Me.Chkbx_asset_management2__checkbox_test_fld3_RebindCheckBoxes()
            Me.Radio_asset_management2__radio_btn_test_fld3_RebindRadioButtons()
        End Sub

        Private Sub Bind_Menu_asset_management2__category()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data.category IsNot Nothing Then
                Dim category As String = data.category.TrimStart(" "c)
                Dim i As Integer = 0
                For Each item As XmlElement In menu_asset_management2__category.Items
                    If item.InnerText.Equals(category) Then
                        menu_asset_management2__category.SelectedIndex = i
                        Return
                    End If
                    i += 1
                Next
            End If
        End Sub

        Private Sub Menu_asset_management2__category_SelectionChanged(ByVal sender As Object, ByVal e As SelectionChangedEventArgs)
            If asset_management2ViewSource IsNot Nothing Then
                Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
                If item.category IsNot Nothing Then
                    item.category = DirectCast(menu_asset_management2__category.SelectedItem, XmlElement).InnerText
                    Me.SaveRecords()
                End If
            End If
        End Sub

        Private Sub Chkbx_asset_management2__book_value_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            item.book_value = 1
            Me.SaveRecords()
        End Sub

        Private Sub Chkbx_asset_management2__book_value_UnChecked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            item.book_value = 0
            Me.SaveRecords()
        End Sub

        Public Sub Chkbx_asset_management2__book_value_RebindCheckBoxes()
            'Uncheck if they haven't been set 
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data IsNot Nothing Then
                If data.book_value Is Nothing Then
                    Return
                End If
                Dim expectedNumber As Decimal = 1
                If data.book_value.[GetType]().Equals(GetType(Decimal)) Then
                    If data.book_value.HasValue Then
                        chkbx_asset_management2__book_value_0.IsChecked = data.book_value.Equals(expectedNumber)
                    Else
                        chkbx_asset_management2__book_value_0.IsChecked = False
                   End If
                End If
            End If
        End Sub

        Private Sub Radio_asset_management2__radio_btn_test_fld2_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim rdButton As RadioButton = DirectCast(sender, RadioButton)
            Dim data As String = TryCast(rdButton.Content, String)

            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            item.radio_btn_test_fld2 = data

            Me.SaveRecords()
        End Sub
        Public Sub Radio_asset_management2__radio_btn_test_fld2_RebindRadioButtons()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)

            If data IsNot Nothing Then
                If data.radio_btn_test_fld2 IsNot Nothing Then
                Select Case data.radio_btn_test_fld2
                    Case "Office Furniture"
                        radio_asset_management2__radio_btn_test_fld2_0.IsChecked = True
                        Exit Select
                    Case "Computers"
                        radio_asset_management2__radio_btn_test_fld2_1.IsChecked = True
                        Exit Select
                    Case "Telephones"
                        radio_asset_management2__radio_btn_test_fld2_2.IsChecked = True
                        Exit Select
                    Case "-"
                        radio_asset_management2__radio_btn_test_fld2_3.IsChecked = True
                        Exit Select
                End Select
                End If
            End If
        End Sub

        Private Sub Chkbx_asset_management2__checkbox_test_fld2_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim data As String = TryCast(chkBox.Content, String)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If item.checkbox_test_fld2 Is Nothing Then
                Return
            End If
            If Not item.checkbox_test_fld2.Contains(data) Then
                item.checkbox_test_fld2 += vbLf & data
            End If
            Me.SaveRecords()
        End Sub

        Private Sub Chkbx_asset_management2__checkbox_test_fld2_UnChecked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim data As String = TryCast(chkBox.Content, String)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If item.checkbox_test_fld2 Is Nothing Then
                Return
            End If
            If item.checkbox_test_fld2.Contains(data) Then
                item.checkbox_test_fld2.Replace(vbLf & data, String.Empty)
            End If
            Me.SaveRecords()
        End Sub

        Public Sub Chkbx_asset_management2__checkbox_test_fld2_RebindCheckBoxes()
            'Uncheck if they haven't been set 
            chkbx_asset_management2__checkbox_test_fld2_0.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld2_1.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld2_2.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld2_3.IsChecked = False
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data IsNot Nothing Then
                If data.checkbox_test_fld2 Is Nothing Then
                    Return
                End If
                Dim names As String() = data.checkbox_test_fld2.Split(ControlChars.Lf)
                For i As Integer = 0 To names.Length - 1

                    Select Case names(i).TrimStart(" "c)
                    Case "Office Furniture"
                        chkbx_asset_management2__checkbox_test_fld2_0.IsChecked = True
                        Exit Select
                    Case "Computers"
                        chkbx_asset_management2__checkbox_test_fld2_1.IsChecked = True
                        Exit Select
                    Case "Telephones"
                        chkbx_asset_management2__checkbox_test_fld2_2.IsChecked = True
                        Exit Select
                    Case "-"
                        chkbx_asset_management2__checkbox_test_fld2_3.IsChecked = True
                        Exit Select
                            'default:
                            '    throw new ApplicationException(" error ");
                    End Select
                Next
            End If
        End Sub

        Private Sub Radio_asset_management2__radio_btn_test_fld1_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim rdButton As RadioButton = DirectCast(sender, RadioButton)
            Dim data As String = TryCast(rdButton.Content, String)

            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            item.radio_btn_test_fld1 = data

            Me.SaveRecords()
        End Sub
        Public Sub Radio_asset_management2__radio_btn_test_fld1_RebindRadioButtons()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)

            If data IsNot Nothing Then
                If data.radio_btn_test_fld1 IsNot Nothing Then
                Select Case data.radio_btn_test_fld1
                    Case "Office Furniture"
                        radio_asset_management2__radio_btn_test_fld1_0.IsChecked = True
                        Exit Select
                    Case "Computers"
                        radio_asset_management2__radio_btn_test_fld1_1.IsChecked = True
                        Exit Select
                    Case "Telephones"
                        radio_asset_management2__radio_btn_test_fld1_2.IsChecked = True
                        Exit Select
                    Case "Table"
                        radio_asset_management2__radio_btn_test_fld1_3.IsChecked = True
                        Exit Select
                    Case "Chair"
                        radio_asset_management2__radio_btn_test_fld1_4.IsChecked = True
                        Exit Select
                    Case "Router"
                        radio_asset_management2__radio_btn_test_fld1_5.IsChecked = True
                        Exit Select
                End Select
                End If
            End If
        End Sub

        Private Sub Bind_Menu_asset_management2__vl_test_fld1_numeric()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data.vl_test_fld1_numeric IsNot Nothing Then
                Dim vl_test_fld1_numeric As String = data.vl_test_fld1_numeric.ToString(c)
                Dim i As Integer = 0
                For Each item As XmlElement In menu_asset_management2__vl_test_fld1_numeric.Items
                    If item.InnerText.Equals(vl_test_fld1_numeric) Then
                        menu_asset_management2__vl_test_fld1_numeric.SelectedIndex = i
                        Return
                    End If
                    i += 1
                Next
            End If
        End Sub

        Private Sub Menu_asset_management2__vl_test_fld1_numeric_SelectionChanged(ByVal sender As Object, ByVal e As SelectionChangedEventArgs)
            If asset_management2ViewSource IsNot Nothing Then
                Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
                If item.vl_test_fld1_numeric IsNot Nothing Then
                    item.vl_test_fld1_numeric = DirectCast(menu_asset_management2__vl_test_fld1_numeric.SelectedItem, XmlElement).InnerText
                    Me.SaveRecords()
                End If
            End If
        End Sub

        Private Sub Bind_Menu_asset_management2__vl_test_fld2_numeric()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)

            If data.vl_test_fld2_numeric IsNot Nothing Then

                Dim vl_test_fld2_numeric As String = data.vl_test_fld2_numeric.ToString(c)

                Dim i As Integer = 0
                For Each item As XmlElement In menu_asset_management2__vl_test_fld2_numeric.Items
                    If item.InnerText.Equals(vl_test_fld2_numeric) Then
                        menu_asset_management2__vl_test_fld2_numeric.SelectedIndex = i
                        Return
                    End If
                    i += 1
                Next
            End If
        End Sub

        Private Sub Menu_asset_management2__vl_test_fld2_numeric_SelectionChanged(ByVal sender As Object, ByVal e As SelectionChangedEventArgs)
            If asset_management2ViewSource IsNot Nothing Then
                Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
                If item.vl_test_fld2_numeric IsNot Nothing Then
                    item.vl_test_fld2_numeric = DirectCast(menu_asset_management2__vl_test_fld2_numeric.SelectedItem, XmlElement).InnerText
                    Me.SaveRecords()
                End If
            End If
        End Sub
        Private Sub Chkbx_asset_management2__checkbox_test_fld1_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim data As String = TryCast(chkBox.Content, String)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If item.checkbox_test_fld1 Is Nothing Then
                Return
            End If
            If Not item.checkbox_test_fld1.Contains(data) Then
                item.checkbox_test_fld1 += vbLf & data
            End If
            Me.SaveRecords()
        End Sub

        Private Sub Chkbx_asset_management2__checkbox_test_fld1_UnChecked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim data As String = TryCast(chkBox.Content, String)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If item.checkbox_test_fld1 Is Nothing Then
                Return
            End If
            If item.checkbox_test_fld1.Contains(data) Then
                item.checkbox_test_fld1.Replace(vbLf & data, String.Empty)
            End If
            Me.SaveRecords()
        End Sub

        Public Sub Chkbx_asset_management2__checkbox_test_fld1_RebindCheckBoxes()
            'Uncheck if they haven't been set 
            chkbx_asset_management2__checkbox_test_fld1_0.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld1_1.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld1_2.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld1_3.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld1_4.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld1_5.IsChecked = False
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data IsNot Nothing Then
                If data.checkbox_test_fld1 Is Nothing Then
                    Return
                End If
                Dim names As String() = data.checkbox_test_fld1.Split(ControlChars.Lf)
                For i As Integer = 0 To names.Length - 1

                    Select Case names(i).TrimStart(" "c)
                    Case "Office Furniture"
                        chkbx_asset_management2__checkbox_test_fld1_0.IsChecked = True
                        Exit Select
                    Case "Computers"
                        chkbx_asset_management2__checkbox_test_fld1_1.IsChecked = True
                        Exit Select
                    Case "Telephones"
                        chkbx_asset_management2__checkbox_test_fld1_2.IsChecked = True
                        Exit Select
                    Case "Table"
                        chkbx_asset_management2__checkbox_test_fld1_3.IsChecked = True
                        Exit Select
                    Case "Chair"
                        chkbx_asset_management2__checkbox_test_fld1_4.IsChecked = True
                        Exit Select
                    Case "Router"
                        chkbx_asset_management2__checkbox_test_fld1_5.IsChecked = True
                        Exit Select
                            'default:
                            '    throw new ApplicationException(" error ");
                    End Select
                Next
            End If
        End Sub

        Private Sub Bind_Menu_asset_management2__vl_test_fld1_text()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data.vl_test_fld1_text IsNot Nothing Then
                Dim vl_test_fld1_text As String = data.vl_test_fld1_text.TrimStart(" "c)
                Dim i As Integer = 0
                For Each item As XmlElement In menu_asset_management2__vl_test_fld1_text.Items
                    If item.InnerText.Equals(vl_test_fld1_text) Then
                        menu_asset_management2__vl_test_fld1_text.SelectedIndex = i
                        Return
                    End If
                    i += 1
                Next
            End If
        End Sub

        Private Sub Menu_asset_management2__vl_test_fld1_text_SelectionChanged(ByVal sender As Object, ByVal e As SelectionChangedEventArgs)
            If asset_management2ViewSource IsNot Nothing Then
                Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
                If item.vl_test_fld1_text IsNot Nothing Then
                    item.vl_test_fld1_text = DirectCast(menu_asset_management2__vl_test_fld1_text.SelectedItem, XmlElement).InnerText
                    Me.SaveRecords()
                End If
            End If
        End Sub

        Private Sub Chkbx_asset_management2__checkbox_test_fld3_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim data As String = TryCast(chkBox.Content, String)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If item.checkbox_test_fld3 Is Nothing Then
                Return
            End If
            If Not item.checkbox_test_fld3.Contains(data) Then
                item.checkbox_test_fld3 += vbLf & data
            End If
            Me.SaveRecords()
        End Sub

        Private Sub Chkbx_asset_management2__checkbox_test_fld3_UnChecked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim chkBox As CheckBox = DirectCast(sender, CheckBox)
            Dim data As String = TryCast(chkBox.Content, String)
            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If item.checkbox_test_fld3 Is Nothing Then
                Return
            End If
            If item.checkbox_test_fld3.Contains(data) Then
                item.checkbox_test_fld3.Replace(vbLf & data, String.Empty)
            End If
            Me.SaveRecords()
        End Sub

        Public Sub Chkbx_asset_management2__checkbox_test_fld3_RebindCheckBoxes()
            'Uncheck if they haven't been set 
            chkbx_asset_management2__checkbox_test_fld3_0.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld3_1.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld3_2.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld3_3.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld3_4.IsChecked = False
            chkbx_asset_management2__checkbox_test_fld3_5.IsChecked = False
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            If data IsNot Nothing Then
                If data.checkbox_test_fld3 Is Nothing Then
                    Return
                End If
                Dim names As String() = data.checkbox_test_fld3.Split(ControlChars.Lf)
                For i As Integer = 0 To names.Length - 1

                    Select Case names(i).TrimStart(" "c)
                    Case "Office Furniture"
                        chkbx_asset_management2__checkbox_test_fld3_0.IsChecked = True
                        Exit Select
                    Case "Computers"
                        chkbx_asset_management2__checkbox_test_fld3_1.IsChecked = True
                        Exit Select
                    Case "Telephones"
                        chkbx_asset_management2__checkbox_test_fld3_2.IsChecked = True
                        Exit Select
                    Case "Table"
                        chkbx_asset_management2__checkbox_test_fld3_3.IsChecked = True
                        Exit Select
                    Case "Chair"
                        chkbx_asset_management2__checkbox_test_fld3_4.IsChecked = True
                        Exit Select
                    Case "Router"
                        chkbx_asset_management2__checkbox_test_fld3_5.IsChecked = True
                        Exit Select
                            'default:
                            '    throw new ApplicationException(" error ");
                    End Select
                Next
            End If
        End Sub

        Private Sub Radio_asset_management2__radio_btn_test_fld3_Checked(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim rdButton As RadioButton = DirectCast(sender, RadioButton)
            Dim data As String = TryCast(rdButton.Content, String)

            Dim item = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)
            item.radio_btn_test_fld3 = data

            Me.SaveRecords()
        End Sub
        Public Sub Radio_asset_management2__radio_btn_test_fld3_RebindRadioButtons()
            Dim data = DirectCast(asset_management2ViewSource.View.CurrentItem, asset_management2)

            If data IsNot Nothing Then
                If data.radio_btn_test_fld3 IsNot Nothing Then
                Select Case data.radio_btn_test_fld3
                    Case "Office Furniture"
                        radio_asset_management2__radio_btn_test_fld3_0.IsChecked = True
                        Exit Select
                    Case "Computers"
                        radio_asset_management2__radio_btn_test_fld3_1.IsChecked = True
                        Exit Select
                    Case "Telephones"
                        radio_asset_management2__radio_btn_test_fld3_2.IsChecked = True
                        Exit Select
                    Case "Table"
                        radio_asset_management2__radio_btn_test_fld3_3.IsChecked = True
                        Exit Select
                    Case "Chair"
                        radio_asset_management2__radio_btn_test_fld3_4.IsChecked = True
                        Exit Select
                    Case "Router"
                        radio_asset_management2__radio_btn_test_fld3_5.IsChecked = True
                        Exit Select
                End Select
                End If
            End If
        End Sub


    End Class
End Namespace
