Imports System
Imports System.Collections.Generic
Imports System.Linq
Imports System.Text
Imports System.ComponentModel
Imports System.Windows
Imports System.Windows.Controls
Imports System.Windows.Data
Imports System.Windows.Documents
Imports System.Windows.Input
Imports System.Windows.Media
Imports System.Windows.Media.Imaging
Imports System.Windows.Shapes

Namespace Assets002ns
    Public MustInherit Class WindowBase
        Inherits Window
        Implements INotifyPropertyChanged

        Protected Friend MustOverride Property CurrentRecordPosition() As Double

        Protected Friend MustOverride ReadOnly Property TotalRecords() As Integer

        Public Sub HandleToolbarButton_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
            Dim buttonName As String = TryCast(sender, Button).Name
            Select Case buttonName
                Case "btnPreviousRecord"
                    Me.MoveToPreviousRecord()
                    Me.ReBind()
                    Exit Select
                Case "btnNextRecord"
                    Me.MoveToNextRecord()
                    Me.ReBind()
                    Exit Select
                Case "btnDeleteRecord"
                    Me.DeleteCurrentRecord()
                    Me.ReBind()
                    Exit Select
                Case "btnNewRecord"
                    Me.NewRecord()
                    Me.ReBind()
                    Exit Select
                Case "btnSaveRecord"
                    Me.SaveRecords()
                    Me.ReBind()
                    Exit Select
            End Select
        End Sub

        Protected Friend MustOverride Sub SaveRecords()
        Protected Friend MustOverride Sub NewRecord()
        Protected Friend MustOverride Sub DeleteCurrentRecord()
        Protected Friend MustOverride Sub MoveToNextRecord()
        Protected Friend MustOverride Sub MoveToPreviousRecord()
        Protected Friend MustOverride Sub ReBind()

        Public Event PropertyChanged As PropertyChangedEventHandler _
            Implements INotifyPropertyChanged.PropertyChanged

        Protected Friend Sub NotifyPropertyChanged(ByVal info As [String])
            RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(info))
        End Sub
    End Class
End Namespace
