using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Reflection;
using System.Windows.Markup;

namespace Assets002ns
{
    /// <summary>
    /// Interaction logic for ToolBarUserControl.xaml
    /// </summary>
[ContentPropertyAttribute("ItemsSource")]
    public partial class ToolBarUserControl : UserControl
    {
        private WindowBase  _parentWindow = null;

        public ToolBarUserControl()
        {
//            InitializeComponent();
            this.Loaded += new RoutedEventHandler(MainView_Loaded);
            
        }

        void MainView_Loaded(object sender, RoutedEventArgs e)        
        {
            if (!System.ComponentModel.DesignerProperties.GetIsInDesignMode(this))
            {
                _parentWindow = (WindowBase)Window.GetWindow(this);
                _parentWindow.PropertyChanged += new System.ComponentModel.PropertyChangedEventHandler(_parentWindow_PropertyChanged);

                RebindControls();
            } 
        }


        void _parentWindow_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            RebindControls();
        }

        private void RebindControls()
        {
            txtRecord.Text              = (_parentWindow.CurrentRecordPosition + 1).ToString();
            lbTotalRecords.Content      = "( " + _parentWindow.TotalRecords.ToString() + " )";
            sldRecords.Value            = _parentWindow.CurrentRecordPosition + 1;
            sldRecords.Maximum          = (double)_parentWindow.TotalRecords;
        }
    
        private void cmbWindowSelect_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            ComboBoxItem lbi = ((sender as ComboBox).SelectedItem as ComboBoxItem);
            
            string namespaceType = this.GetType().Namespace;
            string typeName = namespaceType + "." + lbi.Name;
            Type windowType = Assembly.GetExecutingAssembly().GetType(typeName);
            if (windowType != null)
            {
                Window detailWindow = (Window)Activator.CreateInstance(windowType);
                detailWindow.Show();
                detailWindow.Activate();
            }
            else
            {
                throw new ApplicationException("Couldn't find the " + typeName + " in the current Assembly");
            }
        }

        private void btn_Click(object sender, RoutedEventArgs e)
        {
            _parentWindow.HandleToolbarButton_Click(sender, e);
        }

        private void sldRecords_ValueChanged(object sender, RoutedEventArgs e)
        {
            Slider slider = (Slider)sender;

            if (_parentWindow == null)
            {
                return;
            }

            // Only update if the Slider was manually moved
            if (_parentWindow.CurrentRecordPosition != (slider.Value - 1))
            {
                _parentWindow.CurrentRecordPosition = (slider.Value - 1);
            }
        }


    }
}
